﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TMPro;
using UnityEngine.EventSystems;
using UnityEngine.UI;

public class PlayerTwoState : RoleSelectState
{
    public override void OnStartCurrentState()
    {
        //Hide the mask, show the content
        RoleSelect.PlayerTwo.FindChild("Mask").SetActive(false);
        RoleSelect.PlayerTwo.FindChild("Content").Enable();

        PageManager.CurrentPage.DefaultFocusedControl = RoleSelect.PlayerTwo.FindChild("Content").FindChild("CharacterSelector").GetComponent<Selectable>();
        EventSystem.current.SetSelectedGameObject(PageManager.CurrentPage.DefaultFocusedControl.gameObject);
    }

    public override void OnEndCurrentState()
    {
        //This state is ending so Player Two is ready
        RoleSelect.PlayerTwo.FindChild("Mask").FindChild("MaskText").GetComponent<TMP_Text>().SetText("READY");
        RoleSelect.PlayerTwo.FindChild("Mask").SetActive(true);
        RoleSelect.PlayerTwo.FindChild("Content").Disable();
    }
    
    public override void MoveToNextState()
    {
        //Moving on, both players are ready so let's check the selected roles
        RoleSelect.CheckRoles();
    }

    public override void MoveToPreviousState()
    {
        //We're moving back to Player One
        RoleSelect.ChangeCurrentState(new PlayerOneState());
    }
}

